﻿using System;
using System.Net;
using System.Net.Sockets;
using FyndSharp.Utilities.Common;
using gov.va.med.VBECS.Communication.Channels;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.VBECS.Communication.Protocols;

namespace gov.va.med.VBECS.Communication.Clients
{
#if NUNIT
    public
#else
    internal 
#endif        
        class TcpClient<T> : BaseClient<T> where T : IPinger, new()
    {
        private readonly IPEndPoint _serverEndPoint;

        // TODO: possibly remove it
        public TcpClient(IPEndPoint theServerEndPoint)
        {
            _serverEndPoint = theServerEndPoint;
        }


        public TcpClient(IPEndPoint theServerEndPoint, IProtocol protocol)
            : base(protocol)
        {
            _serverEndPoint = theServerEndPoint;
        }

        protected override IChannel CreateCommunicationChannel()
        {
            //*** Fortify Justified Code ***
            // Justified. In the base class BaseClient<T> we make sure that all resources are released at the end.
            return new TcpChannel(ConnectToEndPoint(_serverEndPoint, ConnectTimeout));
            //*** Fortify Justified Code ***
        }

        protected static Socket ConnectToEndPoint(IPEndPoint theEndPoint, int theTimeout)
        {
            Checker.NotNull(theEndPoint);
            var theSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            try
            {
                theSocket.Blocking = false;
                theSocket.Connect(theEndPoint);
                theSocket.Blocking = true;
                return theSocket;
            }
            catch (SocketException socketException)
            {
                if (socketException.ErrorCode != 10035)
                {
                    theSocket.Close();
                    throw;
                }

                if (!theSocket.Poll(theTimeout*1000, SelectMode.SelectWrite))
                {
                    theSocket.Close();
                    throw new TimeoutException("The host failed to connect. Timeout occurred.");
                }

                theSocket.Blocking = true;
                return theSocket;
            }
        }
    }
}